/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.core.ISecurable;
import cofh.api.item.IPlacementUtilItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSecurity
extends ItemMulti
implements IInitializer,
IPlacementUtilItem {
    public static ItemStack lock;

    public ItemSecurity() {
        super("thermalfoundation");
        this.func_77655_b("util");
        this.func_77637_a(ThermalFoundation.tabUtils);
        this.func_77627_a(true);
    }

    private boolean doLockUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        if (ServerHelper.isClientWorld((World)world)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable) {
            if (((ISecurable)tile).setOwner(player.func_146103_bH())) {
                ((ISecurable)tile).setAccess(ISecurable.AccessMode.PUBLIC);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.5f, 0.8f);
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.block.success", new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.security.lock"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.offhandUse"));
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return player.func_175151_a(pos.func_177972_a(facing), facing, player.func_184586_b(hand)) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.doLockUse(player.func_184586_b(hand), player, world, pos) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public boolean onBlockPlacement(ItemStack stack, World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this.doLockUse(stack, player, world, pos);
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("security"));
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        lock = this.addItem(0, "lock");
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addShapedRecipe((ItemStack)lock, (Object[])new Object[]{" S ", "SBS", "SSS", Character.valueOf('B'), "ingotBronze", Character.valueOf('S'), "nuggetSignalum"});
        return true;
    }
}

